/* Copyright (C) 1997-2001 Agilent Technologies */
/* VXIplug&play Instrument Driver for the Agilent E1460*/

#ifndef hpe1460_INCLUDE 
#define hpe1460_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*=============================*/
/*           HPE1460           */
/*=============================*/
/* Framework Revision: WINNT 4.0 */
/*                     WIN95 4.0 */
/* Driver Revision:    A.02.08 */
/* Firmware Revision:  G.09.00 */
/*=============================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   hpe1460.c                 */
/*   hpe1460.h                 */
/*=============================*/

/*=============================*/
/* WIN Framework Files         */
/*=============================*/
/*   hpe1460.def               */
/*   hpe1460.rc                */
/*   hpe1460.bas               */
/*=============================*/

/******  Returned error status values *****/
/* Common Error numbers start at BFFC0D00 */
#define hpe1460_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1460_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1460_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1460_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1460_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1460_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1460_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */
#define hpe1460_INSTR_ERROR_PARAMETER9    (_VI_ERROR+0x3FFC0D20L) /* 0xBFFC0D20 */
#define hpe1460_INSTR_ERROR_PARAMETER10   (_VI_ERROR+0x3FFC0D21L) /* 0xBFFC0D21 */
#define hpe1460_INSTR_ERROR_PARAMETER11   (_VI_ERROR+0x3FFC0D22L) /* 0xBFFC0D22 */
#define hpe1460_INSTR_ERROR_PARAMETER12   (_VI_ERROR+0x3FFC0D23L) /* 0xBFFC0D23 */
#define hpe1460_INSTR_ERROR_PARAMETER13   (_VI_ERROR+0x3FFC0D24L) /* 0xBFFC0D24 */
#define hpe1460_INSTR_ERROR_PARAMETER14   (_VI_ERROR+0x3FFC0D25L) /* 0xBFFC0D25 */
#define hpe1460_INSTR_ERROR_PARAMETER15   (_VI_ERROR+0x3FFC0D26L) /* 0xBFFC0D26 */
#define hpe1460_INSTR_ERROR_PARAMETER16   (_VI_ERROR+0x3FFC0D27L) /* 0xBFFC0D27 */
#define hpe1460_INSTR_ERROR_PARAMETER17   (_VI_ERROR+0x3FFC0D28L) /* 0xBFFC0D28 */
#define hpe1460_INSTR_ERROR_PARAMETER18   (_VI_ERROR+0x3FFC0D29L) /* 0xBFFC0D29 */


#define hpe1460_USER_ERROR_HANDLER			-1

/******   Used by Status System Functions   *****/
#define hpe1460_STB_MAV				5 

#define hpe1460_ESR_OPC				601
#define hpe1460_ESR_QUERY_ERROR			603
#define hpe1460_ESR_DEVICE_DEPENDENT_ERROR		604
#define hpe1460_ESR_EXECUTION_ERROR			605
#define hpe1460_ESR_COMMAND_ERROR			606

#define hpe1460_OPER_SCAN_DONE			809


/******   Used by Function hpe1460_timeOut   *****/
#define  hpe1460_TIMEOUT_MAX  2147483647
#define  hpe1460_TIMEOUT_MIN  0

/* required plug and play functions from VPP-3.1*/
ViStatus _VI_FUNC hpe1460_init (ViRsrc InstrDesc, ViBoolean id_query,
                            ViBoolean do_reset, ViPSession vi );

ViStatus _VI_FUNC hpe1460_close (ViSession vi);

ViStatus _VI_FUNC hpe1460_reset (ViSession vi);

ViStatus _VI_FUNC hpe1460_self_test (ViSession vi, ViPInt16 test_result,
                                 ViChar _VI_FAR test_message[]);

ViStatus _VI_FUNC hpe1460_error_query (ViSession vi, ViPInt32 error_number,
                                   ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC hpe1460_error_message (ViSession vi, ViStatus error_number,
                                     ViChar _VI_FAR message[]);

ViStatus _VI_FUNC hpe1460_revision_query (ViSession vi, ViChar _VI_FAR driver_rev[],
                                      ViChar _VI_FAR instr_rev[]);

/* other standard functions */

ViStatus _VI_FUNC hpe1460_dcl(ViSession vi);

ViStatus _VI_FUNC hpe1460_errorQueryDetect(ViSession vi, ViBoolean errDetect);

ViStatus _VI_FUNC hpe1460_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);

ViStatus _VI_FUNC hpe1460_opc(ViSession vi);

ViStatus _VI_FUNC hpe1460_opc_Q(ViSession vi, ViPInt16 opc);

ViStatus _VI_FUNC hpe1460_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);

ViStatus _VI_FUNC hpe1460_statEvenClr(ViSession vi);

ViStatus _VI_FUNC hpe1460_statEven_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pEvent);

#ifdef INSTR_CALLBACKS

typedef void (_VI_FUNCH _VI_PTR  hpe1460_InstrEventHandler)(
        ViSession vi, ViInt32 happening, ViAddr userData);     
	
ViStatus _VI_FUNC hpe1460_statEvenHdlr(ViSession vi, ViInt32 happening,       
                                   hpe1460_InstrEventHandler eventHandler,
                                   ViAddr userData);

typedef void (_VI_FUNCH _VI_PTR _VI_PTR hpe1460_InstrPEventHandler)(
	ViSession vi, ViInt32 happening, ViAddr userData);

ViStatus _VI_FUNC hpe1460_statEvenHdlr_Q(ViSession vi, ViInt32 happening,
                                     hpe1460_InstrPEventHandler pEventHandler,
                                     ViPAddr pUserData);

ViStatus _VI_FUNC hpe1460_statEvenHdlrDelAll(ViSession vi);
#endif /* INSTR_CALLBACKS */

ViStatus _VI_FUNC hpe1460_timeOut (ViSession vi, ViInt32 timeOut);

ViStatus _VI_FUNC hpe1460_timeOut_Q (ViSession vi, ViPInt32 timeOut);

ViStatus _VI_FUNC hpe1460_trg(ViSession vi);

ViStatus _VI_FUNC hpe1460_wai(ViSession vi);

/* Instr Specific Functions follow */


/******   Used by Function hpe1460_armCoun   *****/
#define  hpe1460_ARM_COUN_MAX  32767
#define  hpe1460_ARM_COUN_MIN  1


/******   Used by Function hpe1460_outpEcltStat_M   *****/
#define  hpe1460_ECLTNUM_MAX  1
#define  hpe1460_ECLTNUM_MIN  0


/******   Used by Function hpe1460_outpEcltStat_M_Q   *****/
/*  hpe1460_ECLTNUM_MAX  */
/*  hpe1460_ECLTNUM_MIN  */


/******   Used by Function hpe1460_outpTtltStat_M   *****/
#define  hpe1460_TTLTNUM_MAX  7
#define  hpe1460_TTLTNUM_MIN  0


/******   Used by Function hpe1460_outpTtltStat_M_Q   *****/
/*  hpe1460_TTLTNUM_MAX  */
/*  hpe1460_TTLTNUM_MIN  */


/******   Used by Function hpe1460_routClos   *****/
#define  hpe1460_CHANNEL_MAX  999999
#define  hpe1460_CHANNEL_MIN  100


/******   Used by Function hpe1460_routClos_Q   *****/
/*  hpe1460_CHANNEL_MAX  */
/*  hpe1460_CHANNEL_MIN  */


/******   Used by Function hpe1460_routFunc   *****/
#define  hpe1460_CARD_MAX  99
#define  hpe1460_CARD_MIN  1
#define  hpe1460_ROUT_FUNC_WIRE1  0
#define  hpe1460_ROUT_FUNC_WIRE2  1
#define  hpe1460_ROUT_FUNC_WIRE2X64  2
#define  hpe1460_ROUT_FUNC_WIRE3  3
#define  hpe1460_ROUT_FUNC_WIRE4  4


/******   Used by Function hpe1460_routFunc_Q   *****/
/*  hpe1460_CARD_MAX  */
/*  hpe1460_CARD_MIN  */
/*  hpe1460_ROUT_FUNC_WIRE1  */
/*  hpe1460_ROUT_FUNC_WIRE2  */
/*  hpe1460_ROUT_FUNC_WIRE2X64  */
/*  hpe1460_ROUT_FUNC_WIRE3  */
/*  hpe1460_ROUT_FUNC_WIRE4  */


/******   Used by Function hpe1460_routOpen   *****/
/*  hpe1460_CHANNEL_MAX  */
/*  hpe1460_CHANNEL_MIN  */


/******   Used by Function hpe1460_routOpen_Q   *****/
/*  hpe1460_CHANNEL_MAX  */
/*  hpe1460_CHANNEL_MIN  */


/******   Used by Function hpe1460_routScanMode   *****/
#define  hpe1460_ROUT_SCAN_MODE_NONE  0
#define  hpe1460_ROUT_SCAN_MODE_FRES  1
#define  hpe1460_ROUT_SCAN_MODE_RES  2
#define  hpe1460_ROUT_SCAN_MODE_VOLT  3


/******   Used by Function hpe1460_routScanMode_Q   *****/
/*  hpe1460_ROUT_SCAN_MODE_NONE  */
/*  hpe1460_ROUT_SCAN_MODE_FRES  */
/*  hpe1460_ROUT_SCAN_MODE_RES  */
/*  hpe1460_ROUT_SCAN_MODE_VOLT  */


/******   Used by Function hpe1460_routScanPort   *****/
#define  hpe1460_ROUT_SCAN_PORT_NONE  0
#define  hpe1460_ROUT_SCAN_PORT_ABUS  1


/******   Used by Function hpe1460_routScanPort_Q   *****/
/*  hpe1460_ROUT_SCAN_PORT_NONE  */
/*  hpe1460_ROUT_SCAN_PORT_ABUS  */


/******   Used by Function hpe1460_setAll1Wire   *****/
/*  hpe1460_CARD_MAX  */
/*  hpe1460_CARD_MIN  */
#define  hpe1460_BANK_7  7
#define  hpe1460_BANK_NONE  -1
/*  hpe1460_BANK_7  */
#define  hpe1460_BANK_6  6
#define  hpe1460_BANK_5  5
#define  hpe1460_BANK_4  4
#define  hpe1460_BANK_3  3
#define  hpe1460_BANK_2  2
#define  hpe1460_BANK_1  1
#define  hpe1460_BANK_0  0
/*  hpe1460_BANK_NONE  */
#define  hpe1460_CHAN_7  7
#define  hpe1460_CHAN_NONE  -1
/*  hpe1460_CHAN_7  */
#define  hpe1460_CHAN_6  6
#define  hpe1460_CHAN_5  5
#define  hpe1460_CHAN_4  4
#define  hpe1460_CHAN_3  3
#define  hpe1460_CHAN_2  2
#define  hpe1460_CHAN_1  1
#define  hpe1460_CHAN_0  0
/*  hpe1460_CHAN_NONE  */
#define  hpe1460_HIGH  1
#define  hpe1460_LOW  0
/*  hpe1460_HIGH  */
/*  hpe1460_LOW  */
#define  hpe1460_CLOSE_CHAN  1
#define  hpe1460_OPEN_CHAN  0
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */


/******   Used by Function hpe1460_setAll2Wire   *****/
/*  hpe1460_CARD_MAX  */
/*  hpe1460_CARD_MIN  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */


/******   Used by Function hpe1460_setAll4Wire   *****/
/*  hpe1460_CARD_MAX  */
/*  hpe1460_CARD_MIN  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_NONE  */
/*  hpe1460_CHAN_0  */
/*  hpe1460_CHAN_1  */
/*  hpe1460_CHAN_2  */
/*  hpe1460_CHAN_3  */
/*  hpe1460_CHAN_4  */
/*  hpe1460_CHAN_5  */
/*  hpe1460_CHAN_6  */
/*  hpe1460_CHAN_7  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */
/*  hpe1460_CLOSE_CHAN  */
/*  hpe1460_OPEN_CHAN  */


/******   Used by Function hpe1460_systCdes_Q   *****/
/*  hpe1460_CARD_MAX  */
/*  hpe1460_CARD_MIN  */


/******   Used by Function hpe1460_systCpon   *****/
/*  hpe1460_CARD_MAX  */
/*  hpe1460_CARD_MIN  */


/******   Used by Function hpe1460_systCtyp_Q   *****/
/*  hpe1460_CARD_MAX  */
/*  hpe1460_CARD_MIN  */


/******   Used by Function hpe1460_trigSour   *****/
#define  hpe1460_TRIG_SOUR_BUS  0
#define  hpe1460_TRIG_SOUR_ECLT0  1
#define  hpe1460_TRIG_SOUR_ECLT1  2
#define  hpe1460_TRIG_SOUR_HOLD  3
#define  hpe1460_TRIG_SOUR_IMM  4
#define  hpe1460_TRIG_SOUR_TTLT0  5
#define  hpe1460_TRIG_SOUR_TTLT1  6
#define  hpe1460_TRIG_SOUR_TTLT2  7
#define  hpe1460_TRIG_SOUR_TTLT3  8
#define  hpe1460_TRIG_SOUR_TTLT4  9
#define  hpe1460_TRIG_SOUR_TTLT5  10
#define  hpe1460_TRIG_SOUR_TTLT6  11
#define  hpe1460_TRIG_SOUR_TTLT7  12
#define  hpe1460_TRIG_SOUR_EXT  13


/******   Used by Function hpe1460_trigSour_Q   *****/
/*  hpe1460_TRIG_SOUR_BUS  */
/*  hpe1460_TRIG_SOUR_ECLT0  */
/*  hpe1460_TRIG_SOUR_ECLT1  */
/*  hpe1460_TRIG_SOUR_HOLD  */
/*  hpe1460_TRIG_SOUR_IMM  */
/*  hpe1460_TRIG_SOUR_TTLT0  */
/*  hpe1460_TRIG_SOUR_TTLT1  */
/*  hpe1460_TRIG_SOUR_TTLT2  */
/*  hpe1460_TRIG_SOUR_TTLT3  */
/*  hpe1460_TRIG_SOUR_TTLT4  */
/*  hpe1460_TRIG_SOUR_TTLT5  */
/*  hpe1460_TRIG_SOUR_TTLT6  */
/*  hpe1460_TRIG_SOUR_TTLT7  */
/*  hpe1460_TRIG_SOUR_EXT  */

ViStatus _VI_FUNC hpe1460_abor  (
  ViSession vi);

ViStatus _VI_FUNC hpe1460_armCoun  (
  ViSession vi,
  ViInt16 armCoun);

ViStatus _VI_FUNC hpe1460_armCoun_Q  (
  ViSession vi,
  ViPInt16 armCoun);

ViStatus _VI_FUNC hpe1460_initCont  (
  ViSession vi,
  ViBoolean initCont);

ViStatus _VI_FUNC hpe1460_initCont_Q  (
  ViSession vi,
  ViPBoolean initCont);

ViStatus _VI_FUNC hpe1460_initImm  (
  ViSession vi);

ViStatus _VI_FUNC hpe1460_outpEcltStat_M  (
  ViSession vi,
  ViInt16 ecltNum,
  ViBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1460_outpEcltStat_M_Q  (
  ViSession vi,
  ViInt16 ecltNum,
  ViPBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1460_outpStat  (
  ViSession vi,
  ViBoolean outpStat);

ViStatus _VI_FUNC hpe1460_outpStat_Q  (
  ViSession vi,
  ViPBoolean outpStat);

ViStatus _VI_FUNC hpe1460_outpTtltStat_M  (
  ViSession vi,
  ViInt16 ttltNum,
  ViBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1460_outpTtltStat_M_Q  (
  ViSession vi,
  ViInt16 ttltNum,
  ViPBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1460_routClos  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1460_routClosList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1460_routClosList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routClosList[]);

ViStatus _VI_FUNC hpe1460_routClos_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routClos);

ViStatus _VI_FUNC hpe1460_routFunc  (
  ViSession vi,
  ViInt16 card,
  ViInt16 routFunc);

ViStatus _VI_FUNC hpe1460_routFunc_Q  (
  ViSession vi,
  ViInt16 card,
  ViPInt16 routFunc);

ViStatus _VI_FUNC hpe1460_routOpen  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1460_routOpenList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1460_routOpenList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routOpenList[]);

ViStatus _VI_FUNC hpe1460_routOpen_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routOpen);

ViStatus _VI_FUNC hpe1460_routScanList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1460_routScanMode  (
  ViSession vi,
  ViInt16 routScanMode);

ViStatus _VI_FUNC hpe1460_routScanMode_Q  (
  ViSession vi,
  ViPInt16 routScanMode);

ViStatus _VI_FUNC hpe1460_routScanPort  (
  ViSession vi,
  ViInt16 routScanPort);

ViStatus _VI_FUNC hpe1460_routScanPort_Q  (
  ViSession vi,
  ViPInt16 routScanPort);

ViStatus _VI_FUNC hpe1460_setAll1Wire  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Bank,
  ViInt16 Channel,
  ViInt16 Terminal,
  ViInt16 Ch992,
  ViInt16 Ch993,
  ViInt16 Ch994);

ViStatus _VI_FUNC hpe1460_setAll2Wire  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Bank0,
  ViInt16 Bank1,
  ViInt16 Bank2,
  ViInt16 Bank3,
  ViInt16 Bank4,
  ViInt16 Bank5,
  ViInt16 Bank6,
  ViInt16 Bank7,
  ViInt16 Ch990,
  ViInt16 Ch991,
  ViInt16 Ch992,
  ViInt16 Ch993,
  ViInt16 Ch994,
  ViInt16 Ch995,
  ViInt16 Ch996);

ViStatus _VI_FUNC hpe1460_setAll4Wire  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Bank0,
  ViInt16 Bank1,
  ViInt16 Bank2,
  ViInt16 Bank3,
  ViInt16 Ch990,
  ViInt16 Ch991,
  ViInt16 Ch992,
  ViInt16 Ch993,
  ViInt16 Ch994,
  ViInt16 Ch995,
  ViInt16 Ch996);

ViStatus _VI_FUNC hpe1460_systCdes_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCdes[]);

ViStatus _VI_FUNC hpe1460_systCpon  (
  ViSession vi,
  ViInt16 card);

ViStatus _VI_FUNC hpe1460_systCtyp_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCtyp[]);

ViStatus _VI_FUNC hpe1460_trigSour  (
  ViSession vi,
  ViInt16 trigSour);

ViStatus _VI_FUNC hpe1460_trigSour_Q  (
  ViSession vi,
  ViPInt16 trigSour);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1460_INCLUDE */

